function [all_last_episodes_K]=simulation_rep(K,alpha,p1,p2,pi1,pi2,threshold,beta,min_episodes)
%The function runs K experiments and returns all_last_episodes_K,
%a K x 4 matrix whose rows are the K experiments and the columns are:
%1: The action chosen in the last episode (1 or 2)
%2: The profit obtained in the last episode
%3: The index of the last episode
%4: The number of consecutive episodes before the end during which the
%player has kept playing the same action

%Initialize
all_last_episodes_K = zeros(K,4);

%Run K experiments.
%Replace "parfor" with "for" to run without parallelization.

parfor k = 1:K
    %Calls the function simulation_exp
    [final_episode] = simulation_exp(alpha,p1,p2,pi1,pi2,threshold,beta,min_episodes);
    %Records the last episode
    all_last_episodes_K(k,:) = final_episode;
    %Uncomment the next line to follow the execution of the code
    %disp(k)
end

